/* ==================== Credits Controller ==================== */

var creditsController = new TKController({
  id: 'credits',
  backButton: '.home',
  scrollableElement : '.credits-content'
});

/* ==================== Animation Management - DidAppear ==================== */

creditsController.viewDidAppear = function(){	
	
	if (IS_APPLE_TV)
	{
		creditsController.showItem1();
		creditsController.showItem2();	
	}
	else
	{
	setTimeout(creditsController.showItem1, 0);
	setTimeout(creditsController.showItem2, 200);
	}
	
	setTimeout(creditsController.showTitle, 000);
}

creditsController.showItem1 = function () {
	var theIntroAnimationElement = document.getElementById("credits_container");
	theIntroAnimationElement.style.opacity = 1;
	theIntroAnimationElement.style.webkitTransform = "scale(1)";
}

creditsController.showItem2 = function () {
var theIntroAnimationElement = document.getElementById("credits_image");
	theIntroAnimationElement.style.opacity = 1;
	theIntroAnimationElement.style.webkitTransform = "scale(1)";
}

creditsController.showTitle = function(){
	var titleImage = document.getElementById("title");
	titleImage.style.webkitTransform = "translateX(0)";
	titleImage.style.opacity = 1;
}

/* ==================== Animation Management - WillDisappear ==================== */

creditsController.viewWillDisappear = function () {
	setTimeout(creditsController.hideTitle, 0);
	setTimeout(creditsController.hideItem1, 0);
	setTimeout(creditsController.hideItem2, 0);
}

creditsController.hideItem1 = function () {

var theIntroAnimationElement1 = document.getElementById("credits_container");
	theIntroAnimationElement1.style.opacity = 0;
	theIntroAnimationElement1.style.webkitTransform = "scale(.5)";
}
creditsController.hideItem2 = function () {

var theIntroAnimationElement1 = document.getElementById("credits_image");
	theIntroAnimationElement1.style.opacity = 0;
	theIntroAnimationElement1.style.webkitTransform = "scale(.8)";
}

creditsController.hideTitle = function(){
	var titleImage = document.getElementById("title");
	titleImage.style.webkitTransform = "translateX(100px)";
	titleImage.style.opacity = 0;
}